function [robust,ori,termi,third] = class_robust(varargin)
%This function uses imreginalmax to find the local max, and imhmax to
%threashold the maximas, then calculate the centroid from the local max.
%Also, find_centroid has type 3, which find_centroid2 does not.
%Synatax:   [pivots,centroid_stk,lum_stk] = class_robust('stks',array,
%                               'theshold',0.5,'type',2,'type2',[0 1],'norm',1)
%Input:     'threshold' = if left off no threshold will be given, if given
%               the value should be between [0 1], and only maxima above
%               the desired level will be counted. Now by Default threshold
%               is 10% or 0.1 for localmax, centroids = 0.1 or 10%
%           type = 1(centroid), 2 (WeightedCentroid) or 0(local max), ...
%               3(all pixels above threshold). default = 0(local max)
%           type2 = 1(Area), 2(Max Intensity), 3(Min Intensity), 4(Pixel #)
%                   5(Integrated Intensity), default = 0(Mean Intensity) 
%                   Note: only works with centroids
%           norm = normalize the images, essentially stretching the image
%                   data over the full bit range.  Only works in centroid
%                   mode.  Default = 1, or on, and will not affect the
%                   intensity  measurements.  If a value between 0 and 1 is
%                   entered then we go into imadjust mode. Note: a norm
%                   value of 0.99 means saturate 1% of pixels.
%           object = output the images of the objects.  Default = 0(off)
%               Does not work with local max
%           save = save the pivots files.  Default = 1 (on)
%           zfilter = filter the objects based on whether then are in
%               multiple slices or not.  Default = 0; 
%Output:    robustness = a matrix, where the z is the ori, the y is the
%               termi, and the x is the third point.
%           ori = vector with the ori center number
%           termi = vector with the termi center number
%           third = vector with teh third center number

[threshold,iter,type,type2,norm,object,zfilter,sav] = parse(varargin);

%open the target images
[oristk,img_range,stks_ch_names1,channel_paths1] = stack_gui(1);  %use cell output mode.
pause(5);
[termistk,img_range,stks_ch_names2,channel_paths2] = stack_gui(1);  %use cell output mode.
pause(5);
[thirdstk,img_range,stks_ch_names3,channel_paths3] = stack_gui(1);  %use cell output mode.
filenames = [stks_ch_names1,stks_ch_names2,stks_ch_names3];     %create a stack name array

%now go through and classify
%initiate
parpool
threshold1 = threshold;
robust = zeros(floor(threshold1/iter),floor(threshold1/iter),floor(threshold1/iter));
third = zeros(1,floor(threshold1/iter));
termi = zeros(1,floor(threshold1/iter));
ori = zeros(1,floor(threshold1/iter));
h = waitbar(0,'Origin at threshold: ','position',[10 50 275 50]);
for i = 1:floor(threshold1/iter)
    waitbar((i/floor(threshold/iter)),h,['Origin at threshold: ',num2str(threshold1)]);   %update progress
    [ori_pivots] = find_centroid_loco(oristk,type,type2,object,norm,threshold1,zfilter,sav,stks_ch_names1,channel_paths1);
    threshold2 = threshold;
    for j = 1:floor(threshold2/iter)
        [termi_pivots] = find_centroid_loco(termistk,type,type2,object,norm,threshold2,zfilter,sav,stks_ch_names2,channel_paths2);
        threshold3 = threshold;
        h2 = waitbar(0,'Classification:');
        for k = 1:floor(threshold3/iter)
            waitbar((k/floor(threshold/iter)),h2,['Classification: Termi @ ',num2str(threshold2),' Third @ ',num2str(threshold3)]);   %update progress
            [third_pivots] = find_centroid_loco(thirdstk,type,type2,object,norm,threshold3,zfilter,sav,stks_ch_names3,channel_paths3);
            vertices = [ori_pivots,termi_pivots,third_pivots];
            %after finding the centroids now classifiy
            [punc_data,alldata] = punc_locodist_loco(vertices,filenames,10,1,1,0.7,0,0);
            [allidx,idx,adata,neardata] = punc_colo_all_loco(alldata,1,3,2,1,1,1,5,2); %class 1
            %-------------------------------------------------(pdata,ori,chan,termi,mod,mod_fltr,pp_fltr,prepost,fltr3)
            robust(j,k,i) = size(cell2mat(adata(1).vert),1);
            threshold3 = threshold3-iter;   %iterate
            third(k)=size(third_pivots{1},1);
        end
        termi(j) = size(termi_pivots{1},1);
        threshold2 = threshold2-iter;   %iterate
        close(h2)
    end
    ori(i) = size(ori_pivots{1},1);
    threshold1 = threshold1-iter;
end
close(h)
delete(gcp('nocreate'))
%save
save([channel_paths1,'robustness',datestr(now,30),'.m'],'robust','ori','termi','third');

%--------------------------------------------------------------------------
function [pivots_out,centroid_stk,lum_stk] = find_centroid_loco(stks,type,type2,object,norm,threshold,zfilter,sav,stks_ch_names,channel_paths)

%initiate labeling of matrix (happy now?!)
mxlabel = {'x','y','z'};

%matlabpool
%lets get straight on calculating the local max
%preallocate
centroid_stk = cell(1,size(stks,2));
lum_stk = cell(1,size(stks,2));
pivots_out = cell(1,size(stks,2));
if object
    object_stk = cell(1,size(stks,2));
    object_lum = cell(1,size(stks,2));
end
for i = 1:size(stks,2)
    stk_tmp = stks{1,i};        %take out the stack to work on.
    if norm==1  %normalize
        stk_tmp = imnorm(stk_tmp);    %normalize the image so that the bit depth is maximized.
    elseif norm>0 && norm<1     %imadjust mode
        lo_hi = stretchlim(max(stk_tmp,[],3),[0 norm]);   %generate the contrast range
        for l = 1:size(stk_tmp,3)   %enhance each image
            stk_tmp(:,:,l) = imadjust(stk_tmp(:,:,l),lo_hi,[]);
        end
    end
    %check for 32bit images
    if strcmp('uint32',class(stk_tmp))
        stk_tmp = im2double2(stk_tmp);  %convert to double for use
    end
    if ~type        %default (local max)
        %stks{1,i} = imhmax(stks{1,i},threshold{1,i});
        stk_tmp(stk_tmp<threshold{1,i}) = 0;
        stks{1,i} = stk_tmp;
        centroid_stk{1,i} = imregionalmax(stks{1,i});
        %enforce object, must be 0
        object = 0;
    else
        stk_bw = false(size(stk_tmp));
        for j = 1:size(stks{1,i},3)     %make the stk Black & White
            stk_bw(:,:,j) = im2bw(stk_tmp(:,:,j),threshold);
        end
        stk_cc = bwconncomp(stk_bw);    %run the connected components analysis
        if zfilter
            pixlst = regionprops(stk_cc,'PixelList');   %find the objects in the volume
            pixidxlst = regionprops(stk_cc,'PixelIdxList');     %get the pixel indexs for the objects
            pixlst = struct2cell(pixlst);    %convert to cell for simple useage
            for n = 1:size(pixlst,2)        %step through the array
                pixtmp(n) = size(unique(pixlst{1,n}(:,3)),1);   %we only care about whether the z is single slice or multi
            end
            rmvidx = find(pixtmp==1);   %find the single slice objects
            pixidxlst(rmvidx) = [];     %remove the single slice objects
            %now convert back to image for later calculations...admittedly I don't
            %need to do this, but to keep the rest of the function the same, I will
            %do this extra step.
            object_idx = cell2mat(struct2cell(pixidxlst)');    %grab the indexs of all of the pixels
            object_tmp = false(size(stk_bw));    %stack holder
            object_tmp(object_idx) = 1;     %create the image
            stk_cc = bwconncomp(object_tmp);   %store
        end
        pixtmp = [];rmvidx = [];pixlst = [];pixidxlst = [];
        switch type  
            case 1    %Centroid
                pivots = regionprops(stk_cc,'Centroid');  %find centroid
                %pivots_out_tmp = cat(1,pivots.Centroid);
            case 2    %WeightedCentroid
                pivots = regionprops(stk_cc,stks{1,i},'WeightedCentroid');
                %pivots_out_tmp = cat(1,pivots.WeightedCentroid);
            case 3  %take all points
                pivots = regionprops(stk_cc,'PixelList');
        end
        lum = [];
        for m = 1:size(type2,2)
            switch type2(m)
                case 1      %area
                    if i==1     %only once
                        mxlabel = [mxlabel 'Area'];
                    end
                    if type==3  %pull all pixels
                        lum_tmp = regionprops(stk_cc,'PixelIdxList');
                        lum_tmp = cell2mat(struct2cell(lum_tmp)');
                        lum = [lum lum_tmp];
                    else    %only objects
                        lum_tmp = regionprops(stk_cc,'Area');
                        lum_tmp = struct2cell(lum_tmp);
                        lum = horzcat(lum,cell2mat(lum_tmp)');
                    end
                case 2      %max intensity
                    if i==1
                        mxlabel = [mxlabel 'MaxIntensity'];
                    end
                    if type==3  %pull all pixels
                        lum_tmp = regionprops(stk_cc,stks{1,i},'PixelValues');
                        lum_tmp = cell2mat(struct2cell(lum_tmp)');
                        lum = [lum lum_tmp];
                    else    %only objects
                        lum_tmp = regionprops(stk_cc,stks{1,i},'MaxIntensity');
                        lum_tmp = struct2cell(lum_tmp);
                        lum = horzcat(lum,cell2mat(lum_tmp)');
                    end
                case 3      %min intensity
                    if i==1
                        mxlabel = [mxlabel 'MinIntensity'];
                    end
                    if type==3  %pull all pixels
                        lum_tmp = regionprops(stk_cc,stks{1,i},'PixelValues');
                        lum_tmp = cell2mat(struct2cell(lum_tmp)');
                        lum = [lum lum_tmp];
                    else    %only objects
                        lum_tmp = regionprops(stk_cc,stks{1,i},'MinIntensity');
                        lum_tmp = struct2cell(lum_tmp);
                        lum = horzcat(lum,cell2mat(lum_tmp)');
                    end
                case 4      %Pixel Number
                    if i==1
                        mxlabel = [mxlabel 'VoxelNumber'];
                    end
                    if type==3  %pull all pixels
                        lum_tmp = regionprops(stk_cc,'PixelIdxList');
                        lum_tmp = cell2mat(struct2cell(lum_tmp)');
                        lum = [lum lum_tmp];
                    else %only objects
                        lum_tmp = regionprops(stk_cc,'PixelIdxList');
                        lum_tmp = struct2cell(lum_tmp);
                        for l = 1:size(lum_tmp,2); lum_tmp{l} = size(lum_tmp{l},1); end
                        lum = horzcat(lum,cell2mat(lum_tmp)');
                    end
                case 5      %Intensity Integrated
                    if i==1
                        mxlabel = [mxlabel 'IntegratedIntensity'];
                    end
                    if type==3  %pull all pixels
                        lum_tmp = regionprops(stk_cc,stks{1,i},'PixelValues');
                        lum_tmp = cell2mat(struct2cell(lum_tmp)');
                        lum = [lum lum_tmp];
                    else    %only objects
                        lum_tmp = regionprops(stk_cc,stk_tmp,'PixelValue');
                        lum_tmp = struct2cell(lum_tmp);
                        for l = 1:size(lum_tmp,2); lum_tmp{l} = sum(lum_tmp{l}); end
                        lum = horzcat(lum,cell2mat(lum_tmp)');
                    end
                otherwise
                    if i==1
                        mxlabel = [mxlabel 'MeanIntensity'];
                    end
                    if type==3  %pull all pixels
                        lum_tmp = regionprops(stk_cc,stks{1,i},'PixelValues');
                        lum_tmp = cell2mat(struct2cell(lum_tmp)');
                        lum = [lum lum_tmp];
                    else    %only objects
                        lum_tmp = regionprops(stk_cc,stks{1,i},'MeanIntensity');    %find the intensity of the regions
                        lum_tmp = struct2cell(lum_tmp);
                        lum = horzcat(lum,cell2mat(lum_tmp)');
                    end
            end
            lum_tmp = [];
        end
        stk_tmp = false(size(stks{1,i}));  %create a logical array the same size as the original array
        %pivots is currently a structure, convert to cell then matrix
        pivots = cell2mat(struct2cell(pivots)');
        %now make the pivots output by adding lum
        pivots_out_tmp = [pivots lum];
        %round pivots to use as pixel indexs
        pivots = round(pivots);
        %now calculate the indexs for the centroid locations
        [x,y,z] = size(stk_tmp);        %stack size
        pivots_idx = ((pivots(:,1)-1).*x)+pivots(:,2)+((x*y).*(pivots(:,3)-1));
        %modify stk_tmp
        stk_tmp(pivots_idx) = 1;
        centroid_stk{1,i} = stk_tmp;
        pivots_out{1,i} = pivots_out_tmp;
        if object   %if object is on
            object_idx = cell2mat(struct2cell(regionprops(stk_cc,'PixelIdxList'))');    %grab the indexs of all of the pixels
            object_tmp = false(size(stks{1,i}));    %stack holder
            object_tmp(object_idx) = 1;     %create the image
            object_stk{1,i} = object_tmp;   %store
            object_lum{1,i} = stks{1,i}.*uint16(object_stk{1,i});   %preserve the luminance.
            object_tmp = []; %clear!
        end
        %clear stk_tmp pivots_out_tmp stk_bw
        stk_tmp = []; pivots_out_tmp = [];stk_bw = [];stk_cc = [];
    end
    %Now pickup the brightness at the max
    lum_stk{1,i} = stks{1,i}.*uint16(centroid_stk{1,i});
end

%ok now find the points & the brightness
if ~type   %if local max
    local_max_tmp = [];
    for i = 1:size(centroid_stk,2)
        for j = 1:size(centroid_stk{1,i},3)
            [x_tmp,y_tmp] = find(centroid_stk{1,i}(:,:,j)>0);
            lm_cache = [x_tmp y_tmp repmat(j,size(x_tmp,1),1)];
            local_max_tmp = vertcat(local_max_tmp,lm_cache);
        end
        lum_tmp = double(lum_stk{1,i}(centroid_stk{1,i}));  %cast to double just in case someone will use huge pictures, because uint8 and 16 are limited
        pivots_out{1,i} = [local_max_tmp lum_tmp];
        if i==1
            mxlabel = [mxlabel 'LocalIntensity'];
        end
    end
end

if sav  %save the pivot files
    %localization for macs
    if ispc
        slash = '\';        %Windows directory marker
    else
        slash = '/';        %Mac directory marker
    end
    
    %dynamic path
    switch type
        case 0
            dir_path = ['LocalMaxs',slash];     %where to save it
        case 1
            dir_path = ['Centroids',slash];     %where to save it
        case 2
            dir_path = ['WeightedCentroids',slash];     %where to save it
        case 3
            dir_path = ['TotalPixel',slash];    %here to save it
    end
    
    mkdir(channel_paths,dir_path);      %create output directory
    mkdir(channel_paths,[dir_path,'img_data',filesep]);     %create a directory where the file information is stored
    for i = 1:size(centroid_stk,2)
        warning('OFF')
        %now save the files
        mkdir([channel_paths,dir_path],[stks_ch_names{1,i}(1:end-4),' ',num2str(size(pivots_out{1,i},1))]);
        xls_exp = dataset({pivots_out{1,i},mxlabel{:}});               %to export as a XLS need to make the data a dataset.
        %export(xls_exp,'XLSfile',[[channel_paths,dir_path],[stks_ch_names{1,i},'.xls']]);
        export(xls_exp,'File',[[channel_paths,dir_path],[stks_ch_names{1,i}(1:end-4),'.',num2str(size(pivots_out{1,i},1)),'.csv']],'delimiter',',')
        mkdir([channel_paths,dir_path,stks_ch_names{1,i}(1:end-4),' ',num2str(size(pivots_out{1,i},1))],['lum_stks',slash]);
        stk2tiff(lum_stk{1,i},stks_ch_names{1,i},[channel_paths,dir_path,stks_ch_names{1,i}(1:end-4),' ',num2str(size(pivots_out{1,i},1)),slash,'lum_stks',slash]);
        mkdir([channel_paths,dir_path,stks_ch_names{1,i}(1:end-4),' ',num2str(size(pivots_out{1,i},1))],['centroid_stks',slash]);
        stk2tiff(centroid_stk{1,i},stks_ch_names{1,i},[channel_paths,dir_path,stks_ch_names{1,i}(1:end-4),' ',num2str(size(pivots_out{1,i},1)),slash,'centroid_stks',slash]);
        if object   %save out the object stacks
            mkdir([channel_paths,dir_path,stks_ch_names{1,i}(1:end-4),' ',num2str(size(pivots_out{1,i},1))],['objects_lum',slash]);
            stk2tiff(object_lum{1,i},stks_ch_names{1,i},[channel_paths,dir_path,stks_ch_names{1,i}(1:end-4),' ',num2str(size(pivots_out{1,i},1)),slash,'objects_lum',slash]);
            mkdir([channel_paths,dir_path,stks_ch_names{1,i}(1:end-4),' ',num2str(size(pivots_out{1,i},1))],['objects',slash]);
            stk2tiff(object_stk{1,i},stks_ch_names{1,i},[channel_paths,dir_path,stks_ch_names{1,i}(1:end-4),' ',num2str(size(pivots_out{1,i},1)),slash,'objects',slash]);
        end
        %save some info about the image volume
        img_data = size(stks{i});
        img_data = dataset(img_data);
        export(img_data,'File',[[channel_paths,dir_path,'img_data',filesep],stks_ch_names{1,i}(1:end-4),'_img_data.csv'],'delimiter',',')
        %clear data
        local_max_tmp = []; lum_tmp = []; xls_exp = [];
        warning('ON')
    end
    
    %for historical reasons I am going to save this file, no big.
    export(img_data,'File',[[channel_paths,dir_path,'img_data',filesep],'img_data.csv'],'delimiter',',')
    %matlabpool close
end

%--------------------------------------------------------------------------
%subfunction to parse the inputs.
function [threshold,iter,type,type2,norm,object,zfilter,sav] = parse(input)

threshold = 0.5;    
stks = [];
type = 0;
type2 = 0;      %default is 0; now you can define the accessory data, acquired instead of Luminance
norm = 1;
object = 0;
sav = 0;
zfilter = 0;
iter = 0.02;

%Parse the input
if ~isempty(input)
    for i = 1:2:size(input,2)
        if ischar(input{1,i});
            switch input{1,i}
                case 'threshold'
                    threshold = input{1,i+1};
                case 'iter'
                    iter = input{1,i+1};
                case 'stks'
                    stks = input{1,i+1};
                case 'type'
                    type = input{1,i+1};
                case 'type2'
                    type2 = input{1,i+1};
                case 'norm'
                    norm = input{1,i+1};
                case 'object'
                    object = input{1,i+1};
                case 'zfilter'
                    zfilter = input{1,i+1};
                case 'save'
                    sav = input{1,i+1};
                otherwise
                    warning(['Your input ',input{1,i},' is not recognized.']);
            end
        else
            error(['The parameters you entered is incorrect.  Please check help.']);
        end
    end
end
%--------------------------------------------------------------------------
function [punc_data,all_data] = punc_locodist_loco(vertices,filenames,nhood,x_scale,y_scale,z_scale,noself,skip)
%This function is a nerfed version of punc_metric for distance calculations
%only, and only the nearest point... that helps the user perform a puncta
%wise colocaliztion analysis.  The user will enter a minimum of two x y z
%coordinate lists and the program will spit out a structure of distances
%and vector metrics.
%Synatax:   [punc_data,all_data] = punc_locodist2('nhood',10); 
%Input:     This function does not really require any inputs.  However if
%           you do not want default values then..
%           'nhood' = the search neighborhood around each vertex for its
%                   nearest neighbor.  Default = 5 each direction
%           'center' = value of 1 or 0, 0 = off, 1 = on.  When center is on
%                   calculations for vectors will be made towards a point
%                   between the two defined points, and there will be an
%                   extra dataset for the distance meteric which will
%                   represent the center between the two selected points.
%                   Default = 0.
%           'vector' = value of 1 or 0, 0 = off, 1 = on.  When on the
%                   vector metric will be attempted for the data input.
%                   Default = 1.
%           'x' = the scale, as a ratio or xyz, of 1 unit in the x axis.
%                 Default = 1
%           'y' = the scale, as a ratio or xyz, of 1 unit in the y axis.
%                 Default = 1
%           'z' = the scale, as a ratio or xyz, of 1 unit in the z axis.
%                 Default = 1
%           'nrst_only' = Calculate vector using the nearst points as well. 
%                   otherwise, vector will be calculated using the full
%                   list of vertices in the nhood volumn.  Default = 0/off.
%                   1 = on.
%           'noself' = special case if you want to compare a list to
%                   itself, but don't want all points to be 0.  So, the
%                   nearest point not self.  Default = 0(off)
%           'skip' = skip this channel,e.g. [1 5]. Default = 0.  
%           'path' = the pathname, for now only one pathname is allowed
%           'files' = the filenames in cell string array format
%Output:    Punc_data = a structured array with the data for puncta data
%           The structure of the data set is this:
%             filenames = the filenames of the channels
%             pathnames = where the files are stored
%           Distance Metric:
%             punc_data is a structure of depth x, where x is the number of
%             imported vertices lists, or layers of data
%             punc_data(x).distance = An n by 1 array where n matches the
%               number of verticies in that particular list.
%             punc_data(x).vertices = An n by 3 array of vertices that was
%               used as the ori vertex for generating the distances.
%             punc_data(x).vert_props = an n by m by z matrix, where n is
%               the number of ori vertices, m is the number of properties
%               gathered and z is the number of channels assayed.  In this
%               case the properties are matched the properties of only
%               those vertices that are in a ori-termi pair are stored for
%               each pair.  If there is no pair, NaN is put in its place
%             punc_data(x).vert_all_props = an n by m array, where all of
%               properties of the vertices are store.
%             punc_data(x).termi = n by 3 by z matrix where n is the number
%               of ori vertices, and z is the number of channels, this
%               matrix stores the vertices of all of the termi vertices in
%               the ori-termi pair
%             punc_data(x).termi_prop = n by m by z matrix of all of the
%               properties of the termi vertices in the ori-termi pair.
%             all_data(x).all_termi = n by 1 by z cell array of termi verts
%               matched to each ori vertex (n). z = number of comparision
%               channels
%             all_data(x).all_tprop = n by 1 by z cell array that match the
%               termi vertices.
%             all_data(x).all_dist = n by 1 by z cell array of all 
%               distances for all termi vertices to the ori vertex (n).
%             all_data(x).all_vert = n by 1 by z cell array of matching ori
%               vertices to termi vertices.  In each cell there is a x by 4
%               array, where x by 3 is the vertices and 4 is the oridinal,
%               or the position of this cell in the vertices list.
%             all_data(x).all_prop = n by 1 by z cell array of all 
%               properties for all termi vertices matched to each ori 
%               vertex (n). z = number of channels

%store the file properties
punc_data.filenames = filenames;
%punc_data.vector = 0;               %no vector calculations

%now lets calculate the distance metric
[punc_data,all_data] = distance_cal(filenames,vertices,punc_data,nhood,x_scale,y_scale,z_scale,noself,skip);

%give all data the filenames as well
all_data(1).filenames = filenames;

%--------------------------------------------------------------------------
%subfunction to calculate the distance metric.
function [punc_data,all_data] = distance_cal(filenames,vertices,punc_data,nhood,x_scale,y_scale,z_scale,noself,skip)

%If not subtraction list is presented, do not subtract any point from the
%data structure.
if nargin==4
    sub_list = 0;
end

%parallelize this puppy
%matlabpool      %initiate processes

%now lets calculate the distance metric
%h = waitbar(0,['Data Sets Analyzed: ',filenames{1}],'position',[20 300 275 50]);    %initialize progress bar.
for i = 1:size(filenames,2)      %calculate for each data set
    %seperate out the brightness value
    verti_tmp = vertices{1,i}(:,1:3);     %pull out one data set to work with
    bright_tmp = single(vertices{1,i}(:,4:end));        %brightness data for each vertices
    verti_tmp = single(verti_tmp.*repmat([x_scale y_scale z_scale],size(verti_tmp,1),1));   %scale the vertices to the proper unit
    %preload cell arrays
    dist_tmp = zeros(size(verti_tmp,1),1,size(filenames,2));       %shortest distances
    %verti_match = cell(size(verti_tmp,1),1,size(filenames,2)); %the matching original verticies for the closeset points.
    %v_match_lum = cell(size(verti_tmp,1),1,size(filenames,2)); %the matching luminance values
    %dist_verti_tmp = cell(size(verti_tmp,1),1,size(filenames,2));   %the matching distance matrix to the closest point list. A cell array as well.
    %closest_tmp = cell(size(verti_tmp,1),1,size(filenames,2));  %the closest pivot.  A cell array.
    %closest_lum_tmp = cell(size(verti_tmp,1),1,size(filenames,2));  %the matching lumninace data.  A cell array
    termi_tmp = zeros(size(verti_tmp,1),3,size(filenames,2));       %the termi vertices
    termi_prop_tmp = zeros(size(verti_tmp,1),size(bright_tmp,2),size(filenames,2)); %the termi properties
    %short_tmp = cell(size(verti_tmp,1),1,size(filenames,2));    %The short list.  A cell Array.
    %short_lum_tmp = cell(size(verti_tmp,1),1,size(filenames,2));    %The short list luminance.  A cell array.
    %sl_dist_tmp = cell(size(verti_tmp,1),1,size(filenames,2));     %The short list distances.  A cell Array.
    %sl_verti_match_tmp = cell(size(verti_tmp,1),1,size(filenames,2));   %The matching verticies for the short list points.
    %sl_v_match_lum_tmp = cell(size(verti_tmp,1),1,size(filenames,2));   %The matching luminance data.
    %start progress bar
    %h2 = waitbar(0,['Comparing Data Set: ',filenames{1}],'position',[20 200 275 50]);    %initialize progress bar.
    skip_now = max(i==skip);
    if ~skip_now
        for j = 1:size(filenames,2)      %get the comparision set
            if j~=i
                verti_co_tmp = vertices{1,j}(:,1:3).*repmat([x_scale y_scale z_scale],size(vertices{1,j},1),1);   %scale the vertices to the proper unit
                bright_co_tmp = vertices{1,j}(:,4:end);     %matching brightness data for comparision channel, now include other properties
                %h3 = waitbar(0,'Vertex Distance Analyzed: 0');    %initialize progress bar.
                parfor k = 1:size(verti_tmp,1)     %iterate through each vertex of the set
                    %display(['distance ',filenames{1,i},' ',filenames{1,j},' ',num2str(i),'_',num2str(j),'_',num2str(k)]);
                    [short_list,short_list_lum] = find_neighbors(verti_tmp(k,:),verti_co_tmp,nhood*2,bright_co_tmp);    %get a short list of local pivots (removed:,bright_co_tmp)
                    curr_verti = repmat(verti_tmp(k,:),size(short_list,1),1);         %replicate the current vertex to the size of the short list.
                    if noself       %special case not self
                        [y,x] = find(short_list(:,1)==curr_verti(:,1)&short_list(:,2)==curr_verti(:,2)&short_list(:,3)==curr_verti(:,3));  %find self vertex
                        short_list(y,:) = [];       %gone
                        short_list_lum(y,:) = [];   %gone
                        curr_verti(y,:) = [];       %gone
                    end
                    %now we are going to make this a search in a sphere
                    verti_dist = single(dddist(curr_verti,short_list));     %calculate the distance of the current vertex from all points in the short list.
                    idx = verti_dist>nhood;     %any point actually outside of the specified radius
                    verti_dist(idx) = [];       %gone
                    short_list(idx,:) = [];     %gone
                    short_list_lum(idx,:) = []; %gone
                    curr_verti(idx,:) = [];     %gone
                    if ~isempty(short_list)           %make sure there is something in the neighborhood.
                        [x,y] = find(verti_dist==absmin(verti_dist));   %find the position of the closest point
                        %closest_tmp{k,1,j} = short_list(x,:);           %create a cell array of all the closest points, just in case of multiples.
                        %closest_lum_tmp{k,1,j} = short_list_lum(x,:);   %create a matching cell array of luminance
                        termi_tmp(k,:,j) = short_list(x(1,1),:);        %for now all I care about is the first closest point, switch to closest_tmp for more complete view
                        termi_prop_tmp(k,:,j) = short_list_lum(x(1,1),:);  %termi properties to match termi
                        %verti_match{k,1,j} = repmat(verti_tmp(k,:),size(short_list(x,:),1),1);    %create a matching original verticies for the closets pts.
                        %v_match_lum{k,1,j} = repmat(bright_tmp(k,:),size(short_list(x,:),1),1);
                        %dist_verti_tmp{k,1,j} = verti_dist(x,:);  %create a matching set of distances with the vertices.
                        dist_tmp(k,1,j) = verti_dist(x(1,1),:);              %create a columnar vector of shortest distances
                        vert_prop(k,:,j) = bright_tmp(k,:);         %store the vertices associated properties
                        short_tmp{k,1,j} = single(short_list);    %output the short list as well.
                        short_lum_tmp{k,1,j} = single(short_list_lum);  %output the luminances of the short list as well
                        sl_dist_tmp{k,1,j} = single(verti_dist);  %output the distances for all points in the short list.
                        all_verti{k,1,j} = single([curr_verti repmat(k,size(curr_verti,1),1)]);    %create a matching original verticies for the all near pts & put in the ordinals
                        all_prop{k,1,j} = single(repmat(bright_tmp(k,:),size(curr_verti,1),1));     %create a matching properties array.
                        %sl_verti_match_tmp{k,1,j} = repmat(verti_tmp(k,:),size(short_list,1),1);  %create a matching vertices for the short list
                        %sl_v_match_lum_tmp{k,1,j} = repmat(bright_tmp(k,:),size(short_list,1),1);  %create a matching luminance for the short list
                    else                        %there is no one around me (sad)
                        %closest_tmp{k,1,j} = single([NaN NaN NaN]);           %not a number for easy extraction.
                        %closest_lum_tmp{k,1,j} = single(NaN(1,size(bright_tmp,2)));
                        termi_tmp(k,:,j) = single([NaN NaN NaN]);
                        termi_prop_tmp(k,:,j) = single(NaN(1,size(bright_tmp,2)));
                        %verti_match{k,1,j} = verti_tmp(k,:);
                        %v_match_lum{k,1,j} = bright_tmp(k,:);
                        %dist_verti_tmp{k,1,j} = single(NaN);
                        dist_tmp(k,1,j) = single(NaN);
                        vert_prop(k,:,j) = single(NaN(1,size(bright_tmp,2)));
                        short_tmp{k,1,j} = single([NaN NaN NaN]);    %output the short list as well.
                        short_lum_tmp{k,1,j} = single(NaN(1,size(bright_tmp,2)));
                        sl_dist_tmp{k,1,j} = single(NaN);   %output the distance for short list.
                        all_verti{k,1,j} = single([verti_tmp(k,:) k]);
                        all_prop{k,1,j} = single(bright_tmp(k,:));
                        %sl_verti_match_tmp{k,1,j} = verti_tmp(k,:);  %all by yourself
                        %sl_v_match_lum_tmp{k,1,j} = bright_tmp(k,:);
                    end
                    %waitbar(k/size(verti_tmp,1),h3,['Vertex Distance Analyzed: ',num2str(k)]);   %update progress
                end
                %close(h3);   %close progress bar
                %waitbar(j/size(filenames,2),h2,['Comparing Data Set: ',filenames{j}]);   %update progress
            end
        end
    else    %skipped but need to fill in a couple of things
        vert_prop = bright_tmp;
        short_tmp = zeros(size(verti_tmp));
        short_lum_tmp = zeros(size(verti_tmp,1),size(bright_tmp,2));
        sl_dist_tmp = zeros(size(verti_tmp,1),1);
        all_verti = short_tmp;
        all_prop = short_lum_tmp;
    end
    %store the data. The structure is that the distance is a matrix that
    %corresponds with the vertices list in the rows and with each z step a
    %calculation against another dataset, the self to self comparision data
    %set is all 0.  So 4 datasets, will be a matrix of (x,1,4).  The
    %vertices is just the verticies used to calculate the distance.  The
    %closest_pt dataset is a cell array that matches the verticies list in
    %rows and with each z step representing another dataset, the cell array
    %is used for the instances where there are multiple closest points.
    punc_data(i).distance = single(dist_tmp);       %shortest distances
    punc_data(i).vertices = single(horzcat(verti_tmp,linspace(1,size(verti_tmp,1),size(verti_tmp,1))'));      %the vertices + the oridinals
    punc_data(i).vert_prop = single(vert_prop);     %the property value for only the vertices that have a neighbor in that particular channel
    punc_data(i).vert_all_prop = single(bright_tmp);          %The property value for all of the vertices in this channel
    %punc_data(i).verti_match = verti_match; %the matching original verticies for the closeset points.
    %punc_data(i).v_match_lum = v_match_lum; %the matching luminance values
    %punc_data(i).dist_verti = dist_verti_tmp;   %the matching distance matrix to the closest point list. A cell array as well.
    %punc_data(i).closest_pt = closest_tmp;  %the closest pivot.  A cell array.
    %punc_data(i).closest_prop = closest_lum_tmp;  %the matching property data for the closest pivots.  A cell array
    punc_data(i).termi = single(termi_tmp);         %the matching terminal vertices
    punc_data(i).termi_prop = single(termi_prop_tmp);   %the matching properties for the terminal vertices
    all_data(i).all_termi = short_tmp;    %The short list.  A cell Array.
    all_data(i).all_tprop = short_lum_tmp;    %The short list luminance.  A cell array.
    all_data(i).all_dist = sl_dist_tmp;     %The short list distances.  A cell Array.
    all_data(i).all_vert = all_verti;      %a matching ori vertices array to all_termi.  A cell array.
    all_data(i).all_prop = all_prop;       %a matching ori properties array to all_termi.  A cell array.
    %punc_data(i).sl_verti_match = sl_verti_match_tmp;   %The matching verticies for the short list points.
    %punc_data(i).sl_v_match_lum = sl_v_match_lum_tmp;   %The matching luminance data.
    %clear data for reinitialization
    %clear verti_tmp verti_co_tmp dist_tmp closest_tmp verti_match dist_verti_tmp short_tmp sl_dist_tmp sl_verti_match_tmp bright_tmp bright_co_tmp closest_lum_tmp v_match_lum short_lum_tmp sl_v_match_lum_tmp
    %verti_tmp = []; verti_co_tmp = []; dist_tmp = []; vert_prop = [];bright_tmp = [];short_lum_tmp = [];bright_co_tmp = [];termi_tmp = [];termi_prop_tmp = [];short_list = [];sl_dist_tmp = [];all_verti = [];
    %verti_match = []; v_match_lum = [];sl_verti_match_tmp = []; sl_v_match_lum_tmp =[];dist_verti_tmp = [];closest_tmp = [];closest_lum_tmp = [];
    %short_tmp = []; sl_dist_tmp = [];
    %update progress bars
    %close(h2);   %close progress bar
    %waitbar(i/size(filenames,2),h,['Data Sets Analyzed: ',filenames{i}]);   %update progress
    clear short_lum_tmp sl_dist_tmp all_verti all_prop short_tmp dist_tmp verti_tmp vert_prop bright_tmp termi_tmp termi_prop_tmp
end
%close(h);   %close progress bar
%clear verti_tmp verti_co_tmp dist_tmp closest_tmp verti_match dist_verti_tmp short_tmp sl_dist_tmp sl_verti_match_tmp bright_tmp bright_co_tmp closest_lum_tmp v_match_lum short_lum_tmp sl_v_match_lum_tmp
%matlabpool close %close processes
%--------------------------------------------------------------------------
function [a2b,b2a,ab,idx] = unique_verts_loco(a,b,nhood)
%This function takes two lists of vertices and finds the vertices in each
%that is unique
%Synatax:   [a2b,b2a,ab,idx] = unique_verts(a,b);
%Input:     a = vertices list a(Note: only care about the first 3 points,
%               in a vert array
%           b = vertices list b
%           nhood = the search neighborhood, default = 0, perfect colo
%Output:    a2b = unique verts in a
%           b2a = unique verts in b
%           ab = not unique verts, a cell array, where {1,1} = not unique
%           a, and {1,2} = not unique b.
%           idx = a cell array of indexes for unique and not unique, the
%               first two cells contains the unique a & b, and the last two
%               contain the not unique ab and ba.

if nargin<3
    nhood = 0;  %default = perfect colo
end

%lets make the two data sets the same data type, or else the comparision
%will not be true, especially the case for double and single
if ~isinteger(a) && ~isinteger(b)     %if both are integer they are fine if class is different
    a_type = whos('a');
    b_type = whos('b');
    if ~strcmp(a_type,b_type)
        if isinteger(a)||isinteger(b)   %one number is integer make sure everything is integer
            if isfloat(a)
                a = int16(a);
            elseif isfloat(b)
                b = int16(b);
            end
        else    %both numbers a floats, make sure we don't compare double to single, go down to single.
            if isa(b,'double')
                b = single(b);
            elseif isa(a,'double')
                a = single(a);
            end
        end
    end
end
%find the unique verts in a
a_idx = zeros(size(a,1),1);     %preallocate
ab_idx = zeros(size(a,1),1);
%h = waitbar(0,['Analyzing Array A: ']);    %initialize progress bar.
parfor i = 1:size(a,1)     %remember verts are arranged in vertical arrays
    match = find_neighbors(a(i,1:3),b(:,1:3),nhood);
    if isempty(match)    %unique
        a_idx(i,1) = i;
    else    %not unique
        ab_idx(i,1) = i;
    end
    %waitbar(i/size(a,1),h,['Analyzing Array A: ',num2str(i)]); %update progress
end
%close(h)

%now create the unique array
a_idx(a_idx==0) = [];       %remove the zeros
ab_idx(ab_idx==0) = [];
a2b = a(a_idx,:);         %unique a vertices
ab{1,1} = sortrows(a(ab_idx,:));         %not unique, should be the same as b
idx{1,1} = a_idx;   %unique a index
idx{1,3} = ab_idx;  %not unique a index

%find the unique verts in b
b_idx = zeros(size(b,1),1);     %preallocate
ab_idx = zeros(size(b,1),1);
%h2 = waitbar(0,['Analyzing Array B: ']);    %initialize progress bar.
parfor j = 1:size(b,1)     %remember verts are arranged in vertical arrays
    match = find_neighbors(b(j,1:3),a(:,1:3),nhood);
    if isempty(match)    %unique
        b_idx(j,1) = j;
        else    %not unique
        ab_idx(j,1) = j;
    end
    %waitbar(j/size(b,1),h2,['Analyzing Array B: ',num2str(j)]); %update progress
end
%close(h2)
%now create the unique array
b_idx(b_idx==0) = [];       %remove the zeros
ab_idx(ab_idx==0) = [];
b2a = b(b_idx,:);         %unique a vertices
ab{1,2} = sortrows(b(ab_idx,:));         %not unique, should be the same as b
idx{1,2} = b_idx;   %unique b index
idx{1,4} = ab_idx;  %not unique b index
%--------------------------------------------------------------------------
function [auidx,auidx2,auidx3] = savpivots_1v3ex_loco(data,alldata,ori,termi,ch1,prepost1,dist,ch3,prepost3,fltr3)
if nargin<10    %choose default for fltr3
    fltr3 = 2;  %on
end

[allidx,idx,adata,neardata] = punc_colo_all(alldata,ori,ch1,'termi',termi,'mod',1,'mod_fltr',1,'pp_fltr',1,'prepost',prepost1,'fltr3',fltr3); %class 1
%[allidx2,idx2,adata2,neardata2] = punc_colo_all(alldata,ori,ch2,'termi',termi,'mod',1,'mod_fltr',1,'pp_fltr',1,'prepost',prepost2,'fltr3',fltr3); %class 2
[allidx3,idx3,adata3,neardata3] = punc_colo_all(alldata,ori,ch3,'termi',termi,'mod',1,'mod_fltr',1,'pp_fltr',1,'prepost',prepost3,'fltr3',fltr3); %class 3

%Lets do the same for alldata
if fltr3==2     %unique filtered all then pull the verts directly
    c1 = cell2mat(adata(1).vert);
    %c2 = cell2mat(adata2(1).vert);
    c3 = cell2mat(adata3(1).vert);
else    %not unique filtered
    c1 = data(ori).vertices;        %grab the ori vertices for the first class(VGluT1)
    c1(allidx,:) = [];                 %The vertices for class 1
    %c2 = data(ori).vertices;        %grab the ori vertices for the second class(VGluT1&2)
    %c2(allidx2,:) = [];                %the vertices for class 2
    c3 = data(ori).vertices;        %grab the ori vertices for the second class(VGluT2)
    c3(allidx3,:) = [];                %the vertices for class 3
end
%compare 1 to 2
[a2b,b2a,ab,vsidx] = unique_verts_loco(c1,c3);   %find the unique vertices
clear a2b b2a ab
%now we are going to go through the shared vertices and place them with
%either 2 (13) or 1 or 3.
atri3 = cell2mat(adata3(1).third);    %grab the cooresponding third vertices
atri1 = cell2mat(adata(1).third);
atri1(vsidx{1},:) = [];      %isolate down to the ones that overlap
atri3(vsidx{2},:) = [];
ad = dddist(atri1,atri3);      %calculate the distance between the two third points
%now filter by distance
atmpidx = find(ad<=dist);     %temporary inclusion matrix
atmpidx2 = find(ad>dist);     %temporary exclusion matrix
%lets create the unique index for class 2
auidx2 = [c1 linspace(1,size(c1,1),size(c1,1))'];         %grab the lot + new ordinals
auidx2(vsidx{1},:) = [];     %pare down to the shared
auidx2(atmpidx2,:) = [];      %now only class 2 vertices
auidx2 = auidx2(:,4);         %take the ordinals and done
auidx2f1 = vsidx{3}(atmpidx,:);   %class 2 from class 1, or the indexed location in class1 where the class 2 pivots come from
auidx2f3 = vsidx{4}(atmpidx,:);   %class 2 from class 3, or the indexed location in class3 where the class 2 pivots come from
%now sort back the other types based on distance from the origin
atprop1 = cell2mat(adata(1).thirdprop);       %grab the properties, which includes the distances
atprop3 = cell2mat(adata3(1).thirdprop);
atprop1 = [atprop1 linspace(1,size(atprop1,1),size(atprop1,1))'];    %tack on its own ordinal
atprop3 = [atprop3 linspace(1,size(atprop3,1),size(atprop3,1))'];    %tack on its own ordinal
atprop1(vsidx{1},:) = [];    %only the ones that overlap
atprop3(vsidx{2},:) = [];
atprop1(atmpidx,:) = 0;       %set to zero the verts that are part of class 2
atprop3(atmpidx,:) = 0;
%now compare the the two properties list: Should be the same distance
%position as the nearest case
atmpidx3 = (atprop1(:,distpos)<atprop3(:,distpos));    %these vertices belong to class 1
tmp3 = atprop1(atmpidx3,:);  %ones belong to class 1
%create unique index
auidx21 = tmp3(:,distpos+1);    %the oridinals, this will generate class1 list that is further from class3 than wanted list
auidx = vertcat(vsidx{1},auidx21);    %the ordinals + the unique indexs
%now vertices that belong to class3
atmpidx4 = (atprop1(:,distpos)>atprop3(:,distpos));    %these vertices belong to class 3
tmp4 = atprop3(atmpidx4,:);  %ones belonging to class 3
%create unique index
auidx23 = tmp4(:,distpos+1);    %the oridinals, this will generate class1 list that is further from class3 than wanted list
auidx3 = vertcat(vsidx{2},auidx23);    %the ordinals + the unique indexs
%--------------------------------------------------------------------------
function [allidx,nidx,all_data,ndata] = punc_colo_all_loco(pdata,ori,chan,termi,mod,mod_fltr,pp_fltr,prepost,fltr3)
%Output:    allidx = the index locations of the ori points that does not
%                   belong to a ori-termi pair that fits criteria.  when
%                   considering the colocalization of all possible
%                   comibinations of one ori to all the other channels,
%                   this is definitely an upperbount.
%           nidx = the index location of the ori points that does not
%                   colocalize based on picking the shortest points colo
%                   events.  A lower bound.
%           all_data = data structure containing all of the classified
%                   colocalization events.
%           n_data = data structure containing the nearest colocalization
%                   event per origin pivot.

%check fltr3 if filter all is activated
if fltr3==2    %filter all activate
    fltrall = 1;    %on
    fltr3 = 1;  %back to something meaningful
else    %go about as usual
    fltrall = 0;    %off
end

%extract out some important data.
filenames = pdata(1).filenames;
%the ori vertices matching termi with properties and distances
overts = [cell2mat(pdata(ori).all_vert(:,:,termi)) cell2mat(pdata(ori).all_prop(:,:,termi)) cell2mat(pdata(ori).all_dist(:,:,termi))];
tverts = [cell2mat(pdata(ori).all_termi(:,:,termi)) cell2mat(pdata(ori).all_tprop(:,:,termi))];     %the termi vertices with properties

%pull out the full dataset to get some global values
ori_props = overts(:,5:end-1);
termi_props = tverts(:,4:end);
meds_ori = median(ori_props(~isnan(ori_props(:,1)),:));    %median
meds_termi = median(termi_props(~isnan(termi_props(:,1)),:));
outlier_fltr_ori = std(ori_props(~isnan(ori_props(:,1)),:))*3+meds_ori;
outlier_fltr_termi = std(termi_props(~isnan(termi_props(:,1)),:))*3+meds_termi;

%reassign overts
overts = pdata(ori).all_vert(:,:,termi);
tverts = pdata(ori).all_termi(:,:,termi);
o_prop = pdata(ori).all_prop(:,:,termi);        %ori properties
t_prop = pdata(ori).all_tprop(:,:,termi);       %termi properties
colo_dist = pdata(ori).all_dist(:,:,termi);     %colocalization distance
idx = [];    %initiate the total index of removal for the cell array

%step through the number of channels.
for i = 1:size(chan,2)
    t_overt = cell(size(overts,1),1);   %initiate the total data array: a structure would be more pleasing, but this will work.
    t_tvert = cell(size(overts,1),1);
    t_3vert = cell(size(overts,1),1);
    t_oprop = cell(size(overts,1),1);
    t_tprop = cell(size(overts,1),1);
    t_3prop = cell(size(overts,1),1);
    t_sort_idx = cell(size(overts,1),1);
    n_overt = cell(size(overts,1),1);   %initiate nearest
    n_tvert = cell(size(overts,1),1);
    n_3vert = cell(size(overts,1),1);
    n_oprop = cell(size(overts,1),1);
    n_tprop = cell(size(overts,1),1);
    n_3prop = cell(size(overts,1),1);
    %ok lets work on the colo channels a bit.  We need to figure out the
    %population propties data and distance data.
    %curr_colo_chan = [pdata(ori).all_termi(:,:,chan(i)) cell2mat(pdata(ori).all_tprop(:,:,chan(i)))];   %the colo channel vertices and prop array
    curr_vert = pdata(ori).all_termi(:,:,chan(i));          %current vertices
    curr_prop = pdata(ori).all_tprop(:,:,chan(i));        %current properties
    curr_dist = pdata(ori).all_dist(:,:,chan(i));         %current distances
    %now get the median & std
    curr_prop_tmp = cell2mat(curr_prop);
    curr_prop_tmp(isnan(curr_prop_tmp(:,1)),:) = [];        %remove NaN
    curr_dist_tmp = cell2mat(curr_dist);
    curr_dist_tmp(isnan(curr_dist_tmp(:,1)),:) = [];        %remove NaN
    med_prop = median(curr_prop_tmp);
    med_dist = median(curr_dist_tmp);
    std_prop = std(curr_prop_tmp);
    std_dist = std(curr_dist_tmp);
    
    %now lets go through each pair and determin if it has a colocalization
    %partner in the 3rd channel.
    cell_idx = zeros(size(curr_vert,1),1);  %initiate the index of removal for the cell array
    %h = waitbar(0,['Processing ' filenames{chan(i)}(1:end-4) ' colocalization: 0']);    %initialize progress bar.
    parfor j = 1:size(overts,1)
        %waitbar(j/size(overts,1),h,['Processing ' filenames{chan(i)}(1:end-4) ' colocalization: ' num2str(j)]);   %update progress
        %now grab ori and termi
        curr_termi = tverts{j,1};
        curr_colo_dist = colo_dist{j,1};
        if ~isnan(curr_termi)  %no need to proceed any furthere if there is no axis.
            curr_ori = overts{j,1};
            curr_oprop = o_prop{j,1};
            curr_tprop = t_prop{j,1};
            %grab the third point
            curr_colo = [curr_vert{j,1} curr_prop{j,1} curr_dist{j,1}];  %This is the THIRD point!
            if ~isnan(curr_colo)        %pointless to proceed if there is no third point
                %now filter out some outliers
                [ydist,x] = find(curr_colo(:,end)>std_dist*3+med_dist);
                yprop = curr_colo(:,4:end-1)>repmat(std_prop.*3+med_prop,size(curr_colo,1),1);
                [yprop,x] = find(yprop(sum(yprop,2)>0));
                %create the modification index of the origin and termi
                if mod
                    %generate ori modification index
                    ori_mod_idx = mean(o_prop{j,1}./repmat(meds_ori,size(curr_ori,1),1),2);
                    termi_mod_idx = mean(t_prop{j,1}./repmat(meds_termi,size(curr_termi,1),1),2);
                    %filter ori for outliers
                    if mod_fltr
                        %create the outlier filter array
                        outlier_fltr_o = outlier_fltr_ori;    %3 std away is too far
                        %now filter out the outliers
                        outlier_fltr_o = outlier_fltr_o<=curr_oprop(1,:);
                        outlier_fltr_o = max(outlier_fltr_o);      %create removal index
                        if ~outlier_fltr_o      %if the ori is an outlier game over.
                            %termi's turn
                            outlier_fltr_t = repmat(outlier_fltr_termi,size(curr_termi,1),1);    %3 std away is too far
                            outlier_fltr_t = outlier_fltr_t<=curr_tprop;
                            outlier_fltr_t = max(outlier_fltr_t,[],2);      %create removal index
                            outlier_fltr_t = find(outlier_fltr_t==1);
                            %remove
                            curr_termi(outlier_fltr_t,:) = [];
                            curr_ori(outlier_fltr_t,:) = [];
                            curr_colo_dist(outlier_fltr_t,:) = [];
                            termi_mod_idx(outlier_fltr_t,:) = [];
                            ori_mod_idx(outlier_fltr_t,:) = [];
                            curr_oprop(outlier_fltr_t,:) = [];
                            curr_tprop(outlier_fltr_t,:) = [];
                        end
                    end
                    %now using the ori and termi mod indexs to create the final mod
                    mod_idx = mean([termi_mod_idx ori_mod_idx],2);
                    %modify or weigh the colocalization distances
                    curr_colo_dist = curr_colo_dist.*mod_idx;
                    %OK now set an upper bound on the colo distance
                    %any modifed distance greater than 2.5um is too far so:
                    curr_colo_dist(curr_colo_dist>25) = 25;     %set to 25
                else
                    outlier_fltr_o = 0; %default no filters
                end
                
                if ~outlier_fltr_o && ~isempty(curr_termi)  %make sure the filter did not remove all the points or the origin
                    %now permute the search in all ways
                    %initiate
                    t_overt_tmp = [];
                    t_tvert_tmp = [];
                    t_oprop_tmp = [];   %distance of 0 is added
                    t_tprop_tmp = [];
                    t_3vert_tmp = [];
                    t_3prop_tmp = [];
                    nearest_tmp = [];
                    t_idx_tmp = [];
                    for k = 1:size(curr_termi,1)
                        %lets filter based on proximity to ori or termi priors
                        if pp_fltr==1  %type 1, recalculate distance based on vertices here
                            pp_comp = curr_colo(:,1:3);  %matching termi (third channel)
                            pp_ori = repmat(curr_ori(1,1:3),size(curr_colo,1),1);  %get the ori vertices & match in size
                            pp_termi = repmat(curr_termi(k,:),size(curr_colo,1),1); %get the actual terminal vertices.
                            %now calculate distances and determine elegibility of the
                            %vertex
                            switch prepost(1,i)
                                case 0      %closer to ori
                                    ypp = dddist(pp_ori,pp_comp)>dddist(pp_termi,pp_comp);
                                case 1i      %closer to termi
                                    ypp = dddist(pp_ori,pp_comp)<dddist(pp_termi,pp_comp);
                                case 100i     %ignostic
                                    ypp = [];  %do not filter anything
                                otherwise       %modify by prepost number
                                    if prepost(1,i)<=0       %closer to ori
                                        ypp = dddist(pp_ori,pp_comp)>dddist(pp_termi,pp_comp)/abs(prepost(1,i));  %ori must be closer than termi
                                    else                    %closer to termi
                                        ypp = dddist(pp_ori,pp_comp)/abs(prepost(1,i))<dddist(pp_termi,pp_comp);  %ori must be further than termi
                                    end
                            end
                        else
                            ypp = [];           %index not used.
                        end
                        ypp = find(ypp==1);     %create actual index
                        %find which one actually is within distance
                        y = repmat(curr_colo_dist(k,1),size(curr_colo,1),1)<curr_colo(:,end);   %compare this permutation
                        y = find(y==1);
                        y = unique(vertcat(y,ypp,ydist,yprop));        %remove all unmatch or unqualified data points
                        curr_colo_tmp = curr_colo;     %lets not mess the the original
                        curr_colo_tmp(y,:) = [];        %get gone
                        %we are going to output two datasets, one is all possible
                        %colocalizations, which is for sure an overcount, and one is
                        %the nearest possible one, which is the floor, but we are not
                        %necessarily picking the correct colocalization event.
                        %all points - upper bound
                        if ~isempty(curr_colo_tmp)&&~isnan(curr_colo_dist(k,1))   %there is a match
                            t_overt_tmp = vertcat(t_overt_tmp,repmat(curr_ori(1,1:4),size(curr_colo_tmp,1),1));
                            t_tvert_tmp = vertcat(t_tvert_tmp,repmat([k curr_termi(k,1:3)],size(curr_colo_tmp,1),1));   %k is added as an ordinal, remove later
                            t_oprop_tmp = vertcat(t_oprop_tmp,horzcat(repmat(curr_oprop(1,1:end),size(curr_colo_tmp,1),1),zeros(size(curr_colo_tmp,1),1)));   %distance of 0 is added
                            t_tprop_tmp = vertcat(t_tprop_tmp,horzcat(repmat(curr_tprop(k,1:end),size(curr_colo_tmp,1),1),repmat(colo_dist{j,1}(k,1),size(curr_colo_tmp,1),1)));
                            t_3vert_tmp = vertcat(t_3vert_tmp,curr_colo_tmp(:,1:3));
                            t_3prop_tmp = vertcat(t_3prop_tmp,curr_colo_tmp(:,4:end));
                            t_idx_tmp = vertcat(t_idx_tmp,k);
                            %nearest points - lower bound
                            nidx = find(curr_colo_tmp(:,end)==min(curr_colo_tmp(:,end)));
                            nearest_tmp = vertcat(nearest_tmp,[repmat(k,size(nidx,1),1)...
                                curr_colo_tmp(nidx,1:end) curr_colo_tmp(nidx,end)+curr_colo_dist(k,1)]);     %k will be used later to pick out the overt and tvert
                            %the distances are summed as to not actually weigh the
                            %distances.
                        else    %there is no match
                            t_idx_tmp = vertcat(t_idx_tmp,nan);
                        end
                    end
                    %now find the nearest overall
                    if ~isempty(nearest_tmp)
                        %all
                        t_overt{j,1} = t_overt_tmp;
                        t_tvert{j,1} = t_tvert_tmp;
                        t_oprop{j,1} = t_oprop_tmp;   %distance of 0 is added
                        t_tprop{j,1} = t_tprop_tmp;
                        t_3vert{j,1} = t_3vert_tmp;
                        t_3prop{j,1} = t_3prop_tmp;
                        t_sort_idx{j,1} = t_idx_tmp;
                        %nearest
                        nidx = find(nearest_tmp(:,end)==min(nearest_tmp(:,end)));
                        nearest_tmp = nearest_tmp(nidx,:);
                        %Ok lets talk a little about contingencies.  I
                        %actually wrote this so it will work, but there is
                        %the smallest of chances that out of all of this
                        %calculation there are two nearest points, in this
                        %case, as you see below, we use the very scientific
                        %pick the first principle.  This isn't completely
                        %evil, because 1) this is really rare, if not then
                        %we got to reconsider this, the other is that it is
                        %what the other all data analysis is all about in
                        %that case both of these points will be kept.
                        n_overt{j,1} = curr_ori(1,1:4);
                        n_tvert{j,1} = curr_termi(nearest_tmp(1,1),1:3);
                        n_oprop{j,1} = [curr_oprop(1,1:end) 0];     %add 0 for distance
                        n_tprop{j,1} = [curr_tprop(nearest_tmp(1,1),1:end) colo_dist{j,1}(nearest_tmp(1,1),1)];    %properties plus distance    
                        n_3vert{j,1} = nearest_tmp(1,2:4);
                        n_3prop{j,1} = nearest_tmp(1,5:end-1);      %get rid of the last number, which is a modified distance
                        n_sort_idx(j,1) = nearest_tmp(1,1);
                    else    %no match
                        cell_idx(j,1) = 1;
                        n_sort_idx(j,1) = 0;
                    end
                else    %fall through no axis, because of filtering
                    cell_idx(j,1) = 1;
                    n_sort_idx(j,1) = 0;
                end
            else %fall through no third point
                 cell_idx(j,1) = 1;
                 n_sort_idx(j,1) = 0;
            end
        else %fall through no axis, second point
            cell_idx(j,1) = 1;
            n_sort_idx(j,1) = 0;
        end
    end
    cell_idx = find(cell_idx==1);   %create actual index
    %store the arrays
    idx = vertcat(idx,cell_idx);
    %close(h);   %close progress bar
    %now create data structure
    all_data(i).name = filenames{chan(i)};  %third point data set
    all_data(i).vert = t_overt;
    all_data(i).oprop = t_oprop;
    all_data(i).termi = t_tvert;
    all_data(i).tprop = t_tprop;
    all_data(i).third = t_3vert;
    all_data(i).thirdprop = t_3prop;
    all_data(i).sort_idx = t_sort_idx;
    ndata(i).name = filenames{chan(i)};  %third point data set
    ndata(i).vert = n_overt;
    ndata(i).oprop = n_oprop;
    ndata(i).termi = n_tvert;
    ndata(i).tprop = n_tprop;
    ndata(i).third = n_3vert;
    ndata(i).thirdprop = n_3prop;
    ndata(i).sort_idx = n_sort_idx;
end

idx = unique(idx);  %the oris that does not colo

%now create the master list, the one where colocalization for all channels
%are considered
%fist deal the nearest point case, because it's simpler.
if size(chan,2)>1   %only need to do this is we are colocalization accross more than three channels
    for l = 1:size(chan,2)
        idx_array(:,l) = ndata(l).sort_idx;   %put all the indexes together
    end
    fidx = mean(idx_array,2);           %if all channels uses the same axis, then the mean is not a fraction.
    fidx = fidx==idx_array(:,1);
    fidx = find(fidx==0);   %generate the final index that removes not matched axes
    nidx = unique(vertcat(idx,fidx));   %this is the almost master index when considering nearest point
    aord_idx = linspace(1,size(all_data(l).third,1),size(all_data(l).third,1))';  %this ordinal index will be used for the final distillation of the all set
    aord_idx(idx,:) = [];
    
    %store the nearest data
    for l = 1:size(chan,2)
        ndata(l).vert(nidx,:) = [];     %wittle down to the final
        ndata(l).oprop(nidx,:) = [];
        ndata(l).termi(nidx,:) = [];
        ndata(l).tprop(nidx,:) = [];
        ndata(l).third(nidx,:) = [];
        ndata(l).thirdprop(nidx,:) = [];
        %instead of doing this "if ~max(idx==m)" lets just remove the non
        %colo events first. for allidx processing down below
        all_data(l).vert(idx,:) = [];     %remove the non-events
        all_data(l).oprop(idx,:) = [];
        all_data(l).termi(idx,:) = [];
        all_data(l).tprop(idx,:) = [];
        all_data(l).third(idx,:) = [];
        all_data(l).thirdprop(idx,:) = [];
        all_data(l).sort_idx(idx,:) = [];
    end
    
    %Now move on to the all data side
    allidx = [];   %starting off point
    h2 = waitbar(0,['Generating colocalizaing matrix for all channels: 0']);    %initialize progress bar.
    for m = 1:size(all_data(1).vert,1)
        waitbar(m/size(all_data(1).vert,1),h2,['Generating colocalization matrix for all channels: ' num2str(m)]);   %update progress
        idx_array = [];
        fidx = [];  
        for n = 1:size(chan,2)
            idx_array(:,n) = all_data(n).sort_idx{m,1};   %put all the indexes together
        end
        fidx = mean(idx_array,2);           %if all channels uses the same axis, then the mean is not a fraction.
        fidx = fidx==idx_array(:,1);
        fidx = find(fidx==1);   %find the ones that colocalize
        if ~isempty(fidx)   %if there are colo events
            for n = 1:size(chan,2)
                termi_tmp = all_data(n).termi{m,1};   %grab one of the termi sets to generated final set index
                curr_idx = [];  %initiate
                for o = size(fidx,1)
                    curr_idx_tmp = find(termi_tmp(:,1)==fidx(o));
                    curr_idx = vertcat(curr_idx,curr_idx_tmp);
                end
                if size(curr_idx,1)==size(termi_tmp,1)  %no change, move on.
                    all_data(n).termi{m,1} = all_data(n).termi{m,1}(:,2:end);   %remove the ordinal
                else    %take out the unwanted
                    %ok now we have the info we need lets finalize the data
                    %structure.
                    all_data(n).vert{m,1} = all_data(n).vert{m,1}(curr_idx,:);     %remove the non-events
                    all_data(n).oprop{m,1} = all_data(n).oprop{m,1}(curr_idx,:);
                    all_data(n).termi{m,1} = all_data(n).termi{m,1}(curr_idx,2:end);    %remove the ordinal
                    all_data(n).tprop{m,1} = all_data(n).tprop{m,1}(curr_idx,:);
                    all_data(n).third{m,1} = all_data(n).third{m,1}(curr_idx,:);
                    all_data(n).thirdprop{m,1} = all_data(n).thirdprop{m,1}(curr_idx,:);
                end
            end
        else  %the point is now removed.
            allidx = vertcat(allidx,m);   %add to the list of non-colo events
        end
    end
    for n = 1:size(chan,2)
        all_data(n).vert(allidx,:) = [];     %remove the non-events
        all_data(n).oprop(allidx,:) = [];
        all_data(n).termi(allidx,:) = [];
        all_data(n).tprop(allidx,:) = [];
        all_data(n).third(allidx,:) = [];
        all_data(n).thirdprop(allidx,:) = [];
    end
    close(h2);   %close progress bar
    aord_idx = aord_idx(allidx,:);
    allidx = unique(vertcat(idx,aord_idx));  %finalize
else
    nidx = idx;
    allidx = idx;
    %store the nearest data
    for l = 1:size(chan,2)
        ndata(l).vert(nidx,:) = [];     %wittle down to the final
        ndata(l).oprop(nidx,:) = [];
        ndata(l).termi(nidx,:) = [];
        ndata(l).tprop(nidx,:) = [];
        ndata(l).third(nidx,:) = [];
        ndata(l).thirdprop(nidx,:) = [];
        %instead of doing this "if ~max(idx==m)" lets just remove the non
        %colo events first. for allidx processing down below
        all_data(l).vert(idx,:) = [];     %remove the non-events
        all_data(l).oprop(idx,:) = [];
        all_data(l).termi(idx,:) = [];
        all_data(l).tprop(idx,:) = [];
        all_data(l).third(idx,:) = [];
        all_data(l).thirdprop(idx,:) = [];
        all_data(l).sort_idx(idx,:) = [];
        %remove the termi ordinals
        for m = 1:size(all_data(1).vert,1)
            all_data(l).termi{m,1} = all_data(l).termi{m,1}(:,2:end);   %remove the ordinal
        end
    end
end

%now filter the using the third channel if it is activated
if fltr3 && size(cell2mat(ndata(1).vert),1)>0
    %ord_idx = linspace(1,size(ndata(l).third,1),size(ndata(l).third,1))';  %the ordinal index will be used for the final distillation of the ndata set
    ord_idx = cell2mat(ndata(1).vert);
    ord_idx = ord_idx(:,4);
    %ord_idx(nidx,:) = [];   %lets get started
    fltr3_idx = [];
    for l = 1:size(chan,2) %step through the channels
        fltr_tmp = [cell2mat(ndata(l).third) cell2mat(ndata(l).thirdprop)];  %pull out the vertices and distances
        %fltr_tmp = [fltr_tmp linspace(1,size(fltr_tmp,1),size(fltr_tmp,1))'];  %append an oridnal system
        [cache,uidx,nuidx] = unique(fltr_tmp(:,1:3),'rows');      %find the unique vertices, uidx = unique index, nuidx = not unique index
        fltr_tmp(uidx,end) = 0;   %for unique vertices, set their distance to 0 as a marker.
        fltr_tmp = [fltr_tmp nuidx];    %this marks each vertex for whether it is unique or not, not binary, but more ordinal like
        fltr_data(:,:,l) = fltr_tmp;    %set it aside
    end
    fltrornot = sum(fltr_data(:,end-1,:),3);    %sum the distances, if 0 do not filter
    for m = 1:size(fltr_data,1)     %step through the dataset
        if fltrornot(m,1)~=0
            for n = 1:size(chan,2)
                if fltr_data(m,end-1,n)~=0  %here is the non-uniqueness
                    x = find(fltr_data(:,end,n)==fltr_data(m,end,n));   %find all instances of the vertex
                    comp_tmp = fltr_data(x,end-1,n);    %grab only the distances
                    comp_idx = find(comp_tmp~=min(comp_tmp));   %find the longer distance
                    x = x(comp_idx);    %these points need to be removed
                    fltr3_idx = vertcat(fltr3_idx,x);   %save it for later use
                    fltr_data(x,end-1,n) = 0;   %don't have to look at the other points again
                end
            end
            fltrornot = sum(fltr_data(:,end-1,:),3);    %if the vertex no longer need to considered then here is how we note that.
        end
    end
    fltr3_idx = unique(fltr3_idx,'rows');   %only need to remove the row once
    for l = 1:size(chan,2)
        ndata(l).vert(fltr3_idx,:) = [];     %wittle down again
        ndata(l).oprop(fltr3_idx,:) = [];
        ndata(l).termi(fltr3_idx,:) = [];
        ndata(l).tprop(fltr3_idx,:) = [];
        ndata(l).third(fltr3_idx,:) = [];
        ndata(l).thirdprop(fltr3_idx,:) = [];
    end
    ord_idx = ord_idx(fltr3_idx,:);  %grab the vertices that are removed from the set.
    %Note: if you want an index for positive selectiob just use ord_idx(fltr3_idx,:) = [].
    
    %so one must consider here that the fltr3 option is somewhat incomplete
    %as it might be adventageous to consider the interaction of nonunique
    %vertices across all possible channels of nonuniqueness, so that the
    %the vertex fate in one channel should affect the mainteance of other
    %hypothetical nonunique points in other channels.  Using this
    %information would be more accurate, but I am not doing it here,
    %because 1) it is actually quite complex to write and I think the cost
    %to benefit is not in favor of it. 2) related to the first point, the
    %occurance of one point being nonunique in multiple channels is rare.
    %3) This is a major point, which is the measure by which we use to
    %measure or calculate the more uniqueness (or which vertex is more
    %likely the real colo event) is itself arbitrary, because we would be
    %using the distance as the supposition that the closer of the two colo
    %events is the real colo event, which is probably true, but not
    %definitely true, and this uncertainty compounds the issue to the point
    %of non-action.  Note: the all case covers the upper bound and all
    %reduduncy anyway.
    nidx = unique(vertcat(nidx,ord_idx));   %this is the master index when considering nearest point
end

%now filter all dataset if it is activated.  Note: current version of this
%all filter is in beta, meaning this is a decent version of it, but a full
%upgrade is coming in the future that will occure with a full rewrite of
%colo_all, which will introduce much more control and accuracy and
%filtering options, plus an upgrade to the data in the data structure,
%which should make filter all even more accurate.  See notebook.

if fltrall
    for n = 1:size(chan,2)  %we'll work on this on a channel by channel basis
        if size(all_data(n).vert,1)>0
            fltrall_idx = [];       %initiate
            rmvcell_idx = [];       %initiate the remove cell index, this if for removing the cell from the original dataset
            %create the sorting matrix: ordinal(from vert),thrid vertices,
            %third distance
            tmp = cell2mat(all_data(n).vert);  %grab the ori vertices and ordinals
            tmp2 = cell2mat(all_data(n).third);     %the third point vertices
            tmp3 = cell2mat(all_data(n).thirdprop);     %we will want the distance of the third from ori
            ord_idx = unique(tmp(:,4));     %grab the ord index, so we know the correspondence of the ordinal and the cell location.
            %put them together
            sort_mat = [tmp(:,4) tmp2 tmp3(:,size(tmp3,2))];
            [cache,sort_idx] = sortrows(sort_mat(:,2:4));     %sort the vertices
            sort_mat = sort_mat(sort_idx,:);        %use the sort index to sort the actual sorting matrix
            curr_vert = sort_mat(1,:);    %initiate using the first vertex
            sort_tmp = curr_vert;   %initate the local sorting matrix
            for o = 2:size(sort_mat,1)  %step through the nonunique ones and parse the data
                vert_tmp = sort_mat(o,:);  %grab the current point
                if curr_vert(1,2:4)==vert_tmp(1,2:4)  %still in the same block of same verts
                    sort_tmp = vertcat(sort_tmp,vert_tmp);  %add point to local sorting matrix.
                else    %new point
                    curr_vert = vert_tmp;   %assign the point to the comparision vertices
                    %now parse the local sorting matrix (this is where the
                    %action is)
                    if size(sort_tmp,1)~=1      %if there is only one member, aka this point is unique skip the checking.
                        uq_tmp = [];    %initiate the matrix of unique third points
                        nuq_tmp = [];   %matrix of not unique third points
                        for p = 1:size(sort_tmp,1)  %go through the local sorting matrix
                            curr_loc = find(ord_idx==sort_tmp(p,1));
                            if size(all_data(n).third{curr_loc,1},1)>1  %this third point is not unique in its ori set
                                nuq_tmp = vertcat(nuq_tmp,sort_tmp(p,:));   %vertex not unique
                            else    %vertex unique
                                uq_tmp = vertcat(uq_tmp,sort_tmp(p,:));
                            end
                        end
                        if isempty(uq_tmp)  %there are no unique vertices
                            nuq_tmp = sortrows(nuq_tmp,5);      %sort it based on distance
                            for q = 2:size(nuq_tmp,1)      %step through and expunge the records, the top is chosen, if 2 the same distance, well we discussed this earlier...
                                curr_loc = find(ord_idx==nuq_tmp(q,1));
                                [rmv_idx] = rmv_vert(nuq_tmp(q,2:4),all_data(n).third{curr_loc,1});   %get the index of removal
                                %now remove the vert
                                all_data(n).vert{curr_loc,1}(rmv_idx,:) = [];
                                all_data(n).oprop{curr_loc,1}(rmv_idx,:) = [];
                                all_data(n).termi{curr_loc,1}(rmv_idx,:) = [];
                                all_data(n).tprop{curr_loc,1}(rmv_idx,:) = [];
                                all_data(n).third{curr_loc,1}(rmv_idx,:) = [];
                                all_data(n).thirdprop{curr_loc,1}(rmv_idx,:) = [];
                                %now check if this point is not empty, if it is, we
                                %will have to remove it completely from the set
                                if isempty(all_data(n).vert{curr_loc,1})
                                    rmvcell_idx = vertcat(rmvcell_idx,nuq_tmp(q,1));
                                    fltrall_idx = vertcat(fltrall_idx,curr_loc);
                                end
                            end
                        else    %there is unique
                            uq_tmp = sortrows(uq_tmp,5);      %sort it based on distance
                            uq_tmp = vertcat(uq_tmp,nuq_tmp);   %put the non unique back to be removed
                            for q = 2:size(uq_tmp,1)      %step through and expunge the records, the top is chosen, if 2 the same distance, well we discussed this earlier...
                                curr_loc = find(ord_idx==uq_tmp(q,1));
                                [rmv_idx] = rmv_vert(uq_tmp(q,2:4),all_data(n).third{curr_loc,1});   %get the index of removal
                                %now remove the vert
                                all_data(n).vert{curr_loc,1}(rmv_idx,:) = [];
                                all_data(n).oprop{curr_loc,1}(rmv_idx,:) = [];
                                all_data(n).termi{curr_loc,1}(rmv_idx,:) = [];
                                all_data(n).tprop{curr_loc,1}(rmv_idx,:) = [];
                                all_data(n).third{curr_loc,1}(rmv_idx,:) = [];
                                all_data(n).thirdprop{curr_loc,1}(rmv_idx,:) = [];
                                %now check if this point is not empty, if it is, we
                                %will have to remove it completely from the set
                                if isempty(all_data(n).vert{curr_loc,1})
                                    rmvcell_idx = vertcat(rmvcell_idx,uq_tmp(q,1));
                                    fltrall_idx = vertcat(fltrall_idx,curr_loc);
                                end
                            end
                        end
                    end
                    sort_tmp = curr_vert;   %reinitate the local sorting matrix
                end
            end
            %remove the verts that were eliminated from the last cycle
            for r = 1:size(chan,2)
                all_data(r).vert(fltrall_idx,:) = [];
                all_data(r).oprop(fltrall_idx,:) = [];
                all_data(r).termi(fltrall_idx,:) = [];
                all_data(r).tprop(fltrall_idx,:) = [];
                all_data(r).third(fltrall_idx,:) = [];
                all_data(r).thirdprop(fltrall_idx,:) = [];
                all_data(r).sort_idx(fltrall_idx,:) = [];
            end
            %reconfigure the all index to remove the points removed here as
            %well.
            allidx = unique(vertcat(allidx,rmvcell_idx));
            %now make sure we are at full parsimony
            thrd_tmp = all_data(n).thirdprop;   %pull data for the third channel one more time
            for s = 1:size(thrd_tmp,1)  %step through the vertices
                if size(thrd_tmp{s,1},1)>1  %there are still more than 1 point
                    %condense
                    curr_tmp = thrd_tmp{s,1};   %pull the set
                    [curr_tmp,curr_idx] = sortrows(curr_tmp,size(curr_tmp,2));     %sort based on distance
                    %we just want the first/closest
                    all_data(n).vert{s,1}(curr_idx(2:end),:) = [];
                    all_data(n).oprop{s,1}(curr_idx(2:end),:) = [];
                    all_data(n).termi{s,1}(curr_idx(2:end),:) = [];
                    all_data(n).tprop{s,1}(curr_idx(2:end),:) = [];
                    all_data(n).third{s,1}(curr_idx(2:end),:) = [];
                    all_data(n).thirdprop{s,1}(curr_idx(2:end),:) = [];
                end
            end
        end
    end
end

%--------------------------------------------------------------------------
%subfunction remove a set of points and return the index of removal
function [idx] = rmv_vert(vert,vert_set)

[y,x] = find(vert_set==repmat(vert,size(vert_set,1),1));  %find in the vertices set where that vertices is

idx = unique(y);    %the row location of that vertex.
